/*===========================================================*/
/* GPS Routines Include File		                     */
/*===========================================================*/


#ifndef _GPS_H_
#define _GPS_H_

/*------------------------------------------------*/
/* Public macros                                  */
/*------------------------------------------------*/


/*------------------------------------------------*/
/* Public types and variables                     */
/*------------------------------------------------*/

typedef struct
{
   uint8_t h,m,s;
} t_time;

typedef struct
{
   int32_t lattitude;
   int32_t longitude;
   int32_t altitude;
   uint16_t speed;
   t_time  time;
   uint8_t satnum;
} t_GPSinfo;

extern t_GPSinfo GPSinfo;

/*------------------------------------------------*/
/* Public funtions                                */
/*------------------------------------------------*/


// parse GGA field
extern void gps_process_GGA(uint8_t *recstr);
// parse VTG field
extern void gps_process_VTG(uint8_t *recstr);

extern int32_t gps_distance(int32_t lattitude1, int32_t lattitude2, 
       		            int32_t longitude1, int32_t longitude2);


#endif


