/*===========================================================*/
/* Serial Port Routines			                     */
/* (c) MSP			                     	     */
/*===========================================================*/

// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this package; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
 

#include "common.h"
#include "serial.h"

static unsigned char		com_old_int;

#define com_cli()								\
   {										\
      CLI(); 									\
      com_old_int = UCSR0B;							\
      UCSR0B = com_old_int & ~((1 << RXCIE0) | (1 << TXCIE0) | (1 << UDRIE0));	\
      SEI();									\
   }

#define com_sei()		UCSR0B |= (1 << RXCIE0) | (1 << TXCIE0) | (com_old_int & (1 << UDRIE0))


int8_t			rx_buf [RX_BUF_SIZE];
uint8_t			rx_buf_ptr;
volatile uint8_t	rx_buf_ready;

       
/*------------------------------------------------*/
/* Serial port initialization                     */
/*------------------------------------------------*/
void com_init (void)
{
   // Initialise variables
   rx_buf_ptr = 0;
   rx_buf_ready = 0;
   
  
   // UART initialisation
   UCSR0B = 0x00;						// disable while setting baud rate
   UCSR0A = 0x00;
   UCSR0C =(1 << UCSZ01) | (1 << UCSZ00);			// no-par, 1 sb, 8b
   UBRR0L = ((F_CPU)/(16 * COM_BAUDRATE) - 1) & 0xFF;		// set baud rate lo
   UBRR0H = (((F_CPU)/(16 * COM_BAUDRATE) - 1) >> 8) & 0xFF;	// set baud rate hi
   UCSR0B = (1 << RXCIE0) | (1 << RXEN0);			// enable interrupts and receiver
}


/*------------------------------------------------*/
/* Serial port receive interrupt handler          */
/*------------------------------------------------*/
SIGNAL (SIG_UART0_RECV)
{
   unsigned char rx_recerror;
   unsigned char rdata;
  
   //uart has received a character in UDR
   com_cli();							// disable serial interrupts; global interrupts enabled
   rx_recerror = UCSR0A & ((1 << FE) | (1 << UPE));		// read error bits
   rdata = UDR0;						// read received data
      
   if (rx_buf_ready == 0)					// buffer empty?
   {
      if (   (rx_recerror != 0)					// error detected, throw away whole packet
	  || (rx_buf_ptr >= RX_BUF_SIZE))
      {
	 rx_buf_ptr = 0;

      } else if (rdata == '$')					// start of packet
      {
	 rx_buf_ptr = 1;
	 rx_buf[0] = rdata;
      
      } else if (   (rdata == 0x0D)				// end of packet
      	         && (rx_buf_ptr > 0))
      {
	 rx_buf_ready = !0;
      
      } else if (rx_buf_ptr > 0)
         rx_buf[rx_buf_ptr++] = rdata;
   } else
   {
      ;								// buffer data overflow (not implemented)
   }

   com_sei();							// enable interrupts
}


 
