/*===========================================================*/
/* Sound generator            				     */
/* (c) MSP			                     	     */
/*===========================================================*/

// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this package; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
 

#include "common.h"
#include "sound.h"


static volatile uint8_t	snd_akt_hi;
static volatile uint8_t	snd_akt_lo;
static volatile uint8_t	snd_cnt;
static volatile uint8_t	snd_lp_cnt;
static volatile uint8_t	snd_mod_ph;				// modulation phase (0=off else on)

static volatile uint32_t sample_ptr;
static volatile uint8_t	 sample_odd;

/*------------------------------------------------*/
/* Generate sound			          */
/* duration - total time x10ms			  */
/* mod - time of sound/silence                    */
/*------------------------------------------------*/
void sound_on(uint8_t loops, uint8_t akt_hi, uint8_t akt_lo)
{
   // Initialise timer 1
   // 16 MHz = 62.5ns/tick
   TCCR1A = (1 << COM1A0);		 			// toggle pin
   OCR1AH = 0x0F;						// set output compare; 16MHz/1KHz = 0x0FA0)
   OCR1AL = 0xA0;

   TCCR1B = (1 << WGM12) | (1 << CS10);				// CTC, prescaller 1
   snd_akt_hi = akt_hi;
   snd_akt_lo = akt_lo;
   snd_cnt = akt_hi;
   snd_lp_cnt = loops;
   snd_mod_ph = 1;
}

/*------------------------------------------------*/
/* Sound interrupt routine                        */
/*------------------------------------------------*/
void sound_tick(void)
{
   if (snd_lp_cnt != 0)						// sound enabled?
   {
      if (--snd_cnt == 0)
      {
	 if (snd_mod_ph != 0)					// switch to silence
	 {
	    snd_mod_ph = 0;
	    TCCR1B = 0x00;
	    snd_cnt = snd_akt_lo;
	    if (--snd_lp_cnt == 0)
	    {
	       TCCR1B = 0x00;
	       TCCR1A = 0x00;
	    }

	 } else
	 {
	    snd_mod_ph = !0;					// sound generation phase
	    TCCR1B = (1 << WGM12) | (1 << CS10);
	    snd_cnt = snd_akt_hi;
	 }
      }
   }
}




