/*===========================================================*/
/* Serial port routines include file           		     */
/*===========================================================*/


#ifndef _SERIAL_H_
#define _SERIAL_H_


#include <windows.h>
#include <winbase.h>


/*------------------------------------------------*/
/* Public macros                                  */
/*------------------------------------------------*/

/*------------------------------------------------*/
/* Public types and variables                     */
/*------------------------------------------------*/

extern long ser_portNumber; 			// COMx port number.
extern long ser_timeout; 			// Desired timeout limit when receiving data.
extern HANDLE ser_handle; 			// Win32 device handle for the com port.
extern COMMTIMEOUTS ser_oldComTimeouts; 	// Store old serial port timeout parameters.
extern unsigned char ser_channelOpen; 		// Is channel open?


/*------------------------------------------------*/
/* Public funtions                                */
/*------------------------------------------------*/

// Serial port initialization
void ser_init(long portnumber, long speed, long timeout);

// Close the communication channel.
void ser_close();

// Transmit a single byte.
void ser_sendbyte( long data );

// Receive a single byte.
long ser_getbyte();

// Flush the transmit buffer.
void ser_flushTX();

// Flush the receive buffer.
void ser_flushRX();

// Transmit multiple bytes.
void ser_sendbuffer( unsigned char * data, DWORD bufsize );

// Receive multiple bytes.
DWORD ser_recbuffer( unsigned char *data, DWORD bufsize );

#endif

